local BabbleTrade=AceLibrary("Babble-Tradeskill-2.2");
local BabbleClass = AceLibrary("Babble-Class-2.2");
local BabbleZone = AceLibrary("Babble-Zone-2.2");
local BabbleInventory=AceLibrary("Babble-Inventory-2.2");
local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");

local RED = "|cffff0000";
local ORANGE = "|cffFF8400";

function AtlasLootSetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Pre 60 Sets
    AtlasLootMenuItem_2_Name:SetText(AL["Pre 60 Sets"]);
    AtlasLootMenuItem_2_Extra:SetText("");
    AtlasLootMenuItem_2_Icon:SetTexture("Interface\\Icons\\INV_Box_01");
    AtlasLootMenuItem_2.type="Sets";
    AtlasLootMenuItem_2.lootpage="PRE60SET";
    AtlasLootMenuItem_2:Show();
    --Crafted Armor Sets
    AtlasLootMenuItem_3_Name:SetText(AL["Crafted Sets"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\INV_Box_01");
    AtlasLootMenuItem_3.type="Sets";
    AtlasLootMenuItem_3.lootpage="CRAFTSET";
    AtlasLootMenuItem_3:Show();
    --Crafted Epic Weapons
    AtlasLootMenuItem_4_Name:SetText(AL["Crafted Epic Weapons"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\INV_Box_01");
    AtlasLootMenuItem_4.type="Sets";
    AtlasLootMenuItem_4.lootpage="CraftedWeapons1";
    AtlasLootMenuItem_4:Show();
    --Legendaries
    AtlasLootMenuItem_5_Name:SetText(AL["Legendary Items"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\INV_Staff_Medivh");
    AtlasLootMenuItem_5.type="Sets";
    AtlasLootMenuItem_5.lootpage="Legendaries";
    AtlasLootMenuItem_5:Show();
    --Rare Mounts
    AtlasLootMenuItem_6_Name:SetText(AL["Rare Mounts"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\INV_Misc_QirajiCrystal_05");
    AtlasLootMenuItem_6.type="Sets";
    AtlasLootMenuItem_6.lootpage="RareMounts";
    AtlasLootMenuItem_6:Show();
    --Tabards
    AtlasLootMenuItem_7_Name:SetText(AL["Tabards"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shirt_GuildTabard_01");
    AtlasLootMenuItem_7.type="Sets";
    AtlasLootMenuItem_7.lootpage="Tabards1";
    AtlasLootMenuItem_7:Show();
    --Hard Mode Tokens: Accessories
    AtlasLootMenuItem_8_Name:SetText(AL["Lvl 70 Instance Token Rewards"]);
    AtlasLootMenuItem_8_Extra:SetText(ORANGE..AL["Accessories"]);
    AtlasLootMenuItem_8_Icon:SetTexture("Interface\\Icons\\Spell_Holy_ChampionsBond");
    AtlasLootMenuItem_8.type="Sets";
    AtlasLootMenuItem_8.lootpage="HardModeToken";
    AtlasLootMenuItem_8:Show();
    --Hard Mode: Armor
    AtlasLootMenuItem_9_Name:SetText(AL["Lvl 70 Instance Token Rewards"]);
    AtlasLootMenuItem_9_Extra:SetText(ORANGE..AL["Armor and Weapons"]);
    AtlasLootMenuItem_9_Icon:SetTexture("Interface\\Icons\\Spell_Holy_ChampionsBond");
    AtlasLootMenuItem_9.type="Sets";
    AtlasLootMenuItem_9.lootpage="HardModeToken3";
    AtlasLootMenuItem_9:Show();
    --Hard Mode Tokens: FR Gear
    AtlasLootMenuItem_10_Name:SetText(AL["Lvl 70 Instance Token Rewards"]);
    AtlasLootMenuItem_10_Extra:SetText(ORANGE..AL["Fire Resistance Gear"]);
    AtlasLootMenuItem_10_Icon:SetTexture("Interface\\Icons\\Spell_Holy_ChampionsBond");
    AtlasLootMenuItem_10.type="Sets";
    AtlasLootMenuItem_10.lootpage="HardModeToken2";
    AtlasLootMenuItem_10:Show();
    --Upper Deck Card Game Items
    AtlasLootMenuItem_11_Name:SetText(AL["Upper Deck Card Game Items"]);
    AtlasLootMenuItem_11_Extra:SetText("");
    AtlasLootMenuItem_11_Icon:SetTexture("Interface\\Icons\\INV_Misc_Ticket_Tarot_Madness");
    AtlasLootMenuItem_11.type="Sets";
    AtlasLootMenuItem_11.lootpage="CardGame1";
    AtlasLootMenuItem_11:Show();
    --Arena PvP - Season 1
    AtlasLootMenuItem_12_Name:SetText(AL["Arena PvP Sets"]);
    AtlasLootMenuItem_12_Extra:SetText(ORANGE..AL["Season 1"]);
    AtlasLootMenuItem_12_Icon:SetTexture("Interface\\Icons\\INV_Mace_36");
    AtlasLootMenuItem_12.type="Sets";
    AtlasLootMenuItem_12.lootpage="ARENASET";
    AtlasLootMenuItem_12:Show();
    --Arena PvP - Season 2
    AtlasLootMenuItem_13_Name:SetText(AL["Arena PvP Sets"]);
    AtlasLootMenuItem_13_Extra:SetText(ORANGE..AL["Season 2"]);
    AtlasLootMenuItem_13_Icon:SetTexture("Interface\\Icons\\INV_Mace_36");
    AtlasLootMenuItem_13.type="Sets";
    AtlasLootMenuItem_13.lootpage="ARENA2SET";
    AtlasLootMenuItem_13:Show();
    --PvP Armor Sets - Level 60
    AtlasLootMenuItem_14_Name:SetText(AL["PvP Armor Sets"]);
    AtlasLootMenuItem_14_Extra:SetText(ORANGE..AL["Level 60"]);
    AtlasLootMenuItem_14_Icon:SetTexture("Interface\\Icons\\INV_Axe_02");
    AtlasLootMenuItem_14.type="Sets";
    AtlasLootMenuItem_14.lootpage="PVPSET";
    AtlasLootMenuItem_14:Show();
    --PvP Armor Sets - Level 70
    AtlasLootMenuItem_15_Name:SetText(AL["PvP Armor Sets"]);
    AtlasLootMenuItem_15_Extra:SetText(ORANGE..AL["Level 70"]);
    AtlasLootMenuItem_15_Icon:SetTexture("Interface\\Icons\\INV_Axe_02");
    AtlasLootMenuItem_15.type="Sets";
    AtlasLootMenuItem_15.lootpage="PVP70SET";
    AtlasLootMenuItem_15:Show();
    --ZG Class Sets
    AtlasLootMenuItem_17_Name:SetText(AL["Zul'Gurub Sets"]);
    AtlasLootMenuItem_17_Extra:SetText("");
    AtlasLootMenuItem_17_Icon:SetTexture("Interface\\Icons\\INV_Jewelry_Necklace_19");
    AtlasLootMenuItem_17.type="Sets";
    AtlasLootMenuItem_17.lootpage="ZGSET";
    AtlasLootMenuItem_17:Show();
    --AQ20 Class Sets
    AtlasLootMenuItem_18_Name:SetText(AL["Ruins of Ahn'Qiraj Sets"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\INV_Jewelry_Ring_AhnQiraj_03");
    AtlasLootMenuItem_18.type="Sets";
    AtlasLootMenuItem_18.lootpage="AQ20SET";
    AtlasLootMenuItem_18:Show();
    --AQ40 Class Sets
    AtlasLootMenuItem_19_Name:SetText(AL["Temple of Ahn'Qiraj Sets"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\INV_Sword_59");
    AtlasLootMenuItem_19.type="Sets";
    AtlasLootMenuItem_19.lootpage="AQ40SET";
    AtlasLootMenuItem_19:Show();
    --Dungeon Set 1/2
    AtlasLootMenuItem_21_Name:SetText(AL["Dungeon 1/2 Sets"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Chest_Chain_03");
    AtlasLootMenuItem_21.type="Sets";
    AtlasLootMenuItem_21.lootpage="T0SET";
    AtlasLootMenuItem_21:Show();
    --Dungeon Set 3
    AtlasLootMenuItem_22_Name:SetText(AL["Dungeon 3 Sets"]);
    AtlasLootMenuItem_22_Extra:SetText("");
    AtlasLootMenuItem_22_Icon:SetTexture("Interface\\Icons\\INV_Helmet_15");
    AtlasLootMenuItem_22.type="Sets";
    AtlasLootMenuItem_22.lootpage="DS3SET";
    AtlasLootMenuItem_22:Show();
    --Tier 1 Sets
    AtlasLootMenuItem_23_Name:SetText(AL["Tier 1 Sets"]);
    AtlasLootMenuItem_23_Extra:SetText("");
    AtlasLootMenuItem_23_Icon:SetTexture("Interface\\Icons\\INV_Pants_Mail_03");
    AtlasLootMenuItem_23.type="Sets";
    AtlasLootMenuItem_23.lootpage="T1SET";
    AtlasLootMenuItem_23:Show();
    --Tier 2 Sets
    AtlasLootMenuItem_24_Name:SetText(AL["Tier 2 Sets"]);
    AtlasLootMenuItem_24_Extra:SetText("");
    AtlasLootMenuItem_24_Icon:SetTexture("Interface\\Icons\\INV_Shoulder_32");
    AtlasLootMenuItem_24.type="Sets";
    AtlasLootMenuItem_24.lootpage="T2SET";
    AtlasLootMenuItem_24:Show();
    --Tier 3 Sets
    AtlasLootMenuItem_25_Name:SetText(AL["Tier 3 Sets"]);
    AtlasLootMenuItem_25_Extra:SetText("");
    AtlasLootMenuItem_25_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_25.type="Sets";
    AtlasLootMenuItem_25.lootpage="T3SET";
    AtlasLootMenuItem_25:Show();
    --Tier 4 Sets
    AtlasLootMenuItem_26_Name:SetText(AL["Tier 4 Sets"]);
    AtlasLootMenuItem_26_Extra:SetText("");
    AtlasLootMenuItem_26_Icon:SetTexture("Interface\\Icons\\INV_Shoulder_14");
    AtlasLootMenuItem_26.type="Sets";
    AtlasLootMenuItem_26.lootpage="T4SET";
    AtlasLootMenuItem_26:Show();
    --Tier 5 Sets
    AtlasLootMenuItem_27_Name:SetText(AL["Tier 5 Sets"]);
    AtlasLootMenuItem_27_Extra:SetText("");
    AtlasLootMenuItem_27_Icon:SetTexture("Interface\\Icons\\INV_Crown_01");
    AtlasLootMenuItem_27.type="Sets";
    AtlasLootMenuItem_27.lootpage="T5SET";
    AtlasLootMenuItem_27:Show();
    -- Tier 6 Sets
    AtlasLootMenuItem_28_Name:SetText(AL["Tier 6 Sets"]);
    AtlasLootMenuItem_28_Extra:SetText("");
    AtlasLootMenuItem_28_Icon:SetTexture("Interface\\Icons\\INV_Gauntlets_63");
    AtlasLootMenuItem_28.type="Sets";
    AtlasLootMenuItem_28.lootpage="T6SET";
    AtlasLootMenuItem_28:Show();
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Collections"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootCraftedSetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT").lootpage = "CRAFTSET2";
    getglobal("AtlasLootItemsFrame_NEXT").title = "|cffFFFFFF"..AL["Crafted Sets"];
    getglobal("AtlasLootItemsFrame_NEXT"):Show();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    --Plate Blacksmithing header
    AtlasLootMenuItem_1_Name:SetText(RED..BabbleTrade["Blacksmithing"]);
    AtlasLootMenuItem_1_Extra:SetText(ORANGE..BabbleInventory["Plate"]);
    AtlasLootMenuItem_1_Icon:SetTexture("Interface\\Icons\\INV_Chest_Plate05");
    AtlasLootMenuItem_1.isheader = true;
    AtlasLootMenuItem_1:Show();
    --Imperial Plate
    AtlasLootMenuItem_2_Name:SetText(AL["Imperial Plate"]);
    AtlasLootMenuItem_2_Extra:SetText("");
    AtlasLootMenuItem_2_Icon:SetTexture("Interface\\Icons\\INV_Belt_01");
    AtlasLootMenuItem_2.type="Subset";
    AtlasLootMenuItem_2.lootpage="ImperialPlate";
    AtlasLootMenuItem_2:Show();
    --The Darksoul
    AtlasLootMenuItem_3_Name:SetText(AL["The Darksoul"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\INV_Shoulder_01");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="TheDarksoul";
    AtlasLootMenuItem_3:Show();
    --Fel Iron Plate
    AtlasLootMenuItem_4_Name:SetText(AL["Fel Iron Plate"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\INV_Chest_Plate07");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="FelIronPlate";
    AtlasLootMenuItem_4:Show();
    --Adamantite Battlegear
    AtlasLootMenuItem_5_Name:SetText(AL["Adamantite Battlegear"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\INV_Gauntlets_30");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="AdamantiteB";
    AtlasLootMenuItem_5:Show();
    --Flame Guard
    AtlasLootMenuItem_6_Name:SetText(AL["Flame Guard"]);
    AtlasLootMenuItem_6_Extra:SetText(ORANGE..AL["Fire Resistance Gear"]);
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\INV_Helmet_22");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="FlameG";
    AtlasLootMenuItem_6:Show();
    --Enchanted Adamantite Armor
    AtlasLootMenuItem_7_Name:SetText(AL["Enchanted Adamantite Armor"]);
    AtlasLootMenuItem_7_Extra:SetText(ORANGE..AL["Arcane Resistance Gear"]);
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Belt_29");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="EnchantedAdaman";
    AtlasLootMenuItem_7:Show();
    --Khorium Ward
    AtlasLootMenuItem_8_Name:SetText(AL["Khorium Ward"]);
    AtlasLootMenuItem_8_Extra:SetText("");
    AtlasLootMenuItem_8_Icon:SetTexture("Interface\\Icons\\INV_Boots_Chain_01");
    AtlasLootMenuItem_8.type="Subset";
    AtlasLootMenuItem_8.lootpage="KhoriumWard";
    AtlasLootMenuItem_8:Show();
    --Faith in Felsteel
    AtlasLootMenuItem_9_Name:SetText(AL["Faith in Felsteel"]);
    AtlasLootMenuItem_9_Extra:SetText("");
    AtlasLootMenuItem_9_Icon:SetTexture("Interface\\Icons\\INV_Pants_Plate_06");
    AtlasLootMenuItem_9.type="Subset";
    AtlasLootMenuItem_9.lootpage="FaithFelsteel";
    AtlasLootMenuItem_9:Show();
    --Burning Rage
    AtlasLootMenuItem_10_Name:SetText(AL["Burning Rage"]);
    AtlasLootMenuItem_10_Extra:SetText("");
    AtlasLootMenuItem_10_Icon:SetTexture("Interface\\Icons\\INV_Gauntlets_26");
    AtlasLootMenuItem_10.type="Subset";
    AtlasLootMenuItem_10.lootpage="BurningRage";
    AtlasLootMenuItem_10:Show();
    --Mail Blacksmithing Header
    AtlasLootMenuItem_12_Name:SetText(RED..BabbleTrade["Blacksmithing"]);
    AtlasLootMenuItem_12_Extra:SetText(ORANGE..BabbleInventory["Mail"]);
    AtlasLootMenuItem_12_Icon:SetTexture("Interface\\Icons\\INV_Chest_Chain_04");
    AtlasLootMenuItem_12.isheader = true;
    AtlasLootMenuItem_12:Show();
    --Bloodsoul Embrace
    AtlasLootMenuItem_13_Name:SetText(AL["Bloodsoul Embrace"]);
    AtlasLootMenuItem_13_Extra:SetText("");
    AtlasLootMenuItem_13_Icon:SetTexture("Interface\\Icons\\INV_Shoulder_15");
    AtlasLootMenuItem_13.type="Subset";
    AtlasLootMenuItem_13.lootpage="BloodsoulEmbrace";
    AtlasLootMenuItem_13:Show();
    --Fel Iron Chain
    AtlasLootMenuItem_14_Name:SetText(AL["Fel Iron Chain"]);
    AtlasLootMenuItem_14_Extra:SetText("");
    AtlasLootMenuItem_14_Icon:SetTexture("Interface\\Icons\\INV_Helmet_35");
    AtlasLootMenuItem_14.type="Subset";
    AtlasLootMenuItem_14.lootpage="FelIronChain";
    AtlasLootMenuItem_14:Show();
    --Tailoring Header
    AtlasLootMenuItem_16_Name:SetText(RED..BabbleTrade["Tailoring"]);
    AtlasLootMenuItem_16_Extra:SetText("");
    AtlasLootMenuItem_16_Icon:SetTexture("Interface\\Icons\\INV_Chest_Cloth_21");
    AtlasLootMenuItem_16.isheader = true;
    AtlasLootMenuItem_16:Show();
    --Bloodvine Garb
    AtlasLootMenuItem_17_Name:SetText(AL["Bloodvine Garb"]);
    AtlasLootMenuItem_17_Extra:SetText("");
    AtlasLootMenuItem_17_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_14");
    AtlasLootMenuItem_17.type="Subset";
    AtlasLootMenuItem_17.lootpage="BloodvineG";
    AtlasLootMenuItem_17:Show();
    --Netherweave Vestments
    AtlasLootMenuItem_18_Name:SetText(AL["Netherweave Vestments"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\INV_Chest_Cloth_29");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="NeatherVest";
    AtlasLootMenuItem_18:Show();
    --Imbued Netherweave
    AtlasLootMenuItem_19_Name:SetText(AL["Imbued Netherweave"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\INV_Pants_Leather_09");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="ImbuedNeather";
    AtlasLootMenuItem_19:Show();
    --Arcanoweave Vestments
    AtlasLootMenuItem_20_Name:SetText(AL["Arcanoweave Vestments"]);
    AtlasLootMenuItem_20_Extra:SetText(ORANGE..AL["Arcane Resistance Gear"]);
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\INV_Chest_Cloth_01");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="ArcanoVest";
    AtlasLootMenuItem_20:Show();
    --The Unyielding
    AtlasLootMenuItem_21_Name:SetText(AL["The Unyielding"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Belt_03");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="TheUnyielding";
    AtlasLootMenuItem_21:Show();
    --Whitemend Wisdom
    AtlasLootMenuItem_22_Name:SetText(AL["Whitemend Wisdom"]);
    AtlasLootMenuItem_22_Extra:SetText("");
    AtlasLootMenuItem_22_Icon:SetTexture("Interface\\Icons\\INV_Helmet_53");
    AtlasLootMenuItem_22.type="Subset";
    AtlasLootMenuItem_22.lootpage="WhitemendWis";
    AtlasLootMenuItem_22:Show();
    --Spellstrike Infusion
    AtlasLootMenuItem_23_Name:SetText(AL["Spellstrike Infusion"]);
    AtlasLootMenuItem_23_Extra:SetText("");
    AtlasLootMenuItem_23_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_14");
    AtlasLootMenuItem_23.type="Subset";
    AtlasLootMenuItem_23.lootpage="SpellstrikeInfu";
    AtlasLootMenuItem_23:Show();
    --Battlecast Garb
    AtlasLootMenuItem_24_Name:SetText(AL["Battlecast Garb"]);
    AtlasLootMenuItem_24_Extra:SetText("");
    AtlasLootMenuItem_24_Icon:SetTexture("Interface\\Icons\\INV_Helmet_70");
    AtlasLootMenuItem_24.type="Subset";
    AtlasLootMenuItem_24.lootpage="BattlecastG";
    AtlasLootMenuItem_24:Show();
    --Soulcloth Embrace
    AtlasLootMenuItem_25_Name:SetText(AL["Soulcloth Embrace"]);
    AtlasLootMenuItem_25_Extra:SetText(ORANGE..AL["Arcane Resistance Gear"]);
    AtlasLootMenuItem_25_Icon:SetTexture("Interface\\Icons\\INV_Chest_Cloth_12");
    AtlasLootMenuItem_25.type="Subset";
    AtlasLootMenuItem_25.lootpage="SoulclothEm";
    AtlasLootMenuItem_25:Show();
    --Primal Mooncloth
    AtlasLootMenuItem_26_Name:SetText(AL["Primal Mooncloth"]);
    AtlasLootMenuItem_26_Extra:SetText(ORANGE..BabbleTrade["Mooncloth Tailoring"]);
    AtlasLootMenuItem_26_Icon:SetTexture("Interface\\Icons\\INV_Chest_Cloth_04");
    AtlasLootMenuItem_26.type="Subset";
    AtlasLootMenuItem_26.lootpage="PrimalMoon";
    AtlasLootMenuItem_26:Show();
    --Shadow's Embrace
    AtlasLootMenuItem_27_Name:SetText(AL["Shadow's Embrace"]);
    AtlasLootMenuItem_27_Extra:SetText(ORANGE..BabbleTrade["Shadoweave Tailoring"]);
    AtlasLootMenuItem_27_Icon:SetTexture("Interface\\Icons\\INV_Shoulder_25");
    AtlasLootMenuItem_27.type="Subset";
    AtlasLootMenuItem_27.lootpage="ShadowEmbrace";
    AtlasLootMenuItem_27:Show();
    --Wrath of Spellfire
    AtlasLootMenuItem_28_Name:SetText(AL["Wrath of Spellfire"]);
    AtlasLootMenuItem_28_Extra:SetText(ORANGE..BabbleTrade["Spellfire Tailoring"]);
    AtlasLootMenuItem_28_Icon:SetTexture("Interface\\Icons\\INV_Gauntlets_19");
    AtlasLootMenuItem_28.type="Subset";
    AtlasLootMenuItem_28.lootpage="SpellfireWrath";
    AtlasLootMenuItem_28:Show();
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Crafted Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootCraftedSetMenu2()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV").lootpage = "CRAFTSET";
    getglobal("AtlasLootItemsFrame_PREV").title = "|cffFFFFFF"..AL["Crafted Sets"];
    getglobal("AtlasLootItemsFrame_PREV"):Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    --Leatherworking Leather Header
    AtlasLootMenuItem_1_Name:SetText(RED..BabbleTrade["Leatherworking"]);
    AtlasLootMenuItem_1_Extra:SetText(ORANGE..BabbleInventory["Leather"]);
    AtlasLootMenuItem_1_Icon:SetTexture("Interface\\Icons\\INV_Chest_Leather_04");
    AtlasLootMenuItem_1.isheader = true;
    AtlasLootMenuItem_1:Show();
    --Volcanic Armor
    AtlasLootMenuItem_2_Name:SetText(AL["Volcanic Armor"]);
    AtlasLootMenuItem_2_Extra:SetText(ORANGE..AL["Fire Resistance Gear"]);
    AtlasLootMenuItem_2_Icon:SetTexture("Interface\\Icons\\INV_Pants_06");
    AtlasLootMenuItem_2.type="Subset";
    AtlasLootMenuItem_2.lootpage="VolcanicArmor";
    AtlasLootMenuItem_2:Show();
    --Ironfeather Armor
    AtlasLootMenuItem_3_Name:SetText(AL["Ironfeather Armor"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\INV_Chest_Leather_06");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="IronfeatherArmor";
    AtlasLootMenuItem_3:Show();
    --Stormshroud Armor
    AtlasLootMenuItem_4_Name:SetText(AL["Stormshroud Armor"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\INV_Chest_Leather_08");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="StormshroudArmor";
    AtlasLootMenuItem_4:Show();
    --Devilsaur Armor
    AtlasLootMenuItem_5_Name:SetText(AL["Devilsaur Armor"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\INV_Pants_Wolf");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="DevilsaurArmor";
    AtlasLootMenuItem_5:Show();
    --Blood Tiger Harness
    AtlasLootMenuItem_6_Name:SetText(AL["Blood Tiger Harness"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\INV_Shoulder_23");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="BloodTigerH";
    AtlasLootMenuItem_6:Show();
    --Primal Batskin
    AtlasLootMenuItem_7_Name:SetText(AL["Primal Batskin"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Chest_Leather_03");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="PrimalBatskin";
    AtlasLootMenuItem_7:Show();
    --Wild Draenish Armor
    AtlasLootMenuItem_8_Name:SetText(AL["Wild Draenish Armor"]);
    AtlasLootMenuItem_8_Extra:SetText("");
    AtlasLootMenuItem_8_Icon:SetTexture("Interface\\Icons\\INV_Pants_Leather_07");
    AtlasLootMenuItem_8.type="Subset";
    AtlasLootMenuItem_8.lootpage="WildDraenishA";
    AtlasLootMenuItem_8:Show();
    --Thick Draenic Armor
    AtlasLootMenuItem_9_Name:SetText(AL["Thick Draenic Armor"]);
    AtlasLootMenuItem_9_Extra:SetText("");
    AtlasLootMenuItem_9_Icon:SetTexture("Interface\\Icons\\INV_Boots_Chain_01");
    AtlasLootMenuItem_9.type="Subset";
    AtlasLootMenuItem_9.lootpage="ThickDraenicA";
    AtlasLootMenuItem_9:Show();
    --Fel Skin
    AtlasLootMenuItem_10_Name:SetText(AL["Fel Skin"]);
    AtlasLootMenuItem_10_Extra:SetText("");
    AtlasLootMenuItem_10_Icon:SetTexture("Interface\\Icons\\INV_Gauntlets_22");
    AtlasLootMenuItem_10.type="Subset";
    AtlasLootMenuItem_10.lootpage="FelSkin";
    AtlasLootMenuItem_10:Show();
    --Strength of the Clefthoof
    AtlasLootMenuItem_11_Name:SetText(AL["Strength of the Clefthoof"]);
    AtlasLootMenuItem_11_Extra:SetText("");
    AtlasLootMenuItem_11_Icon:SetTexture("Interface\\Icons\\INV_Boots_07");
    AtlasLootMenuItem_11.type="Subset";
    AtlasLootMenuItem_11.lootpage="SClefthoof";
    AtlasLootMenuItem_11:Show();
    --Primal Intent
    AtlasLootMenuItem_12_Name:SetText(AL["Primal Intent"]);
    AtlasLootMenuItem_12_Extra:SetText(ORANGE..BabbleTrade["Elemental Leatherworking"]);
    AtlasLootMenuItem_12_Icon:SetTexture("Interface\\Icons\\INV_Chest_Cloth_45");
    AtlasLootMenuItem_12.type="Subset";
    AtlasLootMenuItem_12.lootpage="PrimalIntent";
    AtlasLootMenuItem_12:Show();
    --Windhawk Armor
    AtlasLootMenuItem_13_Name:SetText(AL["Windhawk Armor"]);
    AtlasLootMenuItem_13_Extra:SetText(ORANGE..BabbleTrade["Tribal Leatherworking"]);
    AtlasLootMenuItem_13_Icon:SetTexture("Interface\\Icons\\INV_Chest_Leather_01");
    AtlasLootMenuItem_13.type="Subset";
    AtlasLootMenuItem_13.lootpage="WindhawkArmor";
    AtlasLootMenuItem_13:Show();
    --Leatherworking Leather Header
    AtlasLootMenuItem_16_Name:SetText(RED..BabbleTrade["Leatherworking"]);
    AtlasLootMenuItem_16_Extra:SetText(ORANGE..BabbleInventory["Mail"]);
    AtlasLootMenuItem_16_Icon:SetTexture("Interface\\Icons\\INV_Chest_Chain_12");
    AtlasLootMenuItem_16.isheader = true;
    AtlasLootMenuItem_16:Show();
    --Green Dragon Mail
    AtlasLootMenuItem_17_Name:SetText(AL["Green Dragon Mail"]);
    AtlasLootMenuItem_17_Extra:SetText(ORANGE..AL["Nature Resistance Gear"]);
    AtlasLootMenuItem_17_Icon:SetTexture("Interface\\Icons\\INV_Pants_05");
    AtlasLootMenuItem_17.type="Subset";
    AtlasLootMenuItem_17.lootpage="GreenDragonM";
    AtlasLootMenuItem_17:Show();
    --Blue Dragon Mail
    AtlasLootMenuItem_18_Name:SetText(AL["Blue Dragon Mail"]);
    AtlasLootMenuItem_18_Extra:SetText(ORANGE..AL["Arcane Resistance Gear"]);
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\INV_Chest_Chain_04");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="BlueDragonM";
    AtlasLootMenuItem_18:Show();
    --Black Dragon Mail
    AtlasLootMenuItem_19_Name:SetText(AL["Black Dragon Mail"]);
    AtlasLootMenuItem_19_Extra:SetText(ORANGE..AL["Fire Resistance Gear"]);
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\INV_Pants_03");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="BlackDragonM";
    AtlasLootMenuItem_19:Show();
    --Scaled Draenic Armor
    AtlasLootMenuItem_20_Name:SetText(AL["Scaled Draenic Armor"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\INV_Pants_Mail_07");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="ScaledDraenicA";
    AtlasLootMenuItem_20:Show();
    --Felscale Armor
    AtlasLootMenuItem_21_Name:SetText(AL["Felscale Armor"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Boots_Chain_08");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="FelscaleArmor";
    AtlasLootMenuItem_21:Show();
    --Felstalker Armor
    AtlasLootMenuItem_22_Name:SetText(AL["Felstalker Armor"]);
    AtlasLootMenuItem_22_Extra:SetText("");
    AtlasLootMenuItem_22_Icon:SetTexture("Interface\\Icons\\INV_Belt_13");
    AtlasLootMenuItem_22.type="Subset";
    AtlasLootMenuItem_22.lootpage="FelstalkerArmor";
    AtlasLootMenuItem_22:Show();
    --Fury of the Nether
    AtlasLootMenuItem_23_Name:SetText(AL["Fury of the Nether"]);
    AtlasLootMenuItem_23_Extra:SetText("");
    AtlasLootMenuItem_23_Icon:SetTexture("Interface\\Icons\\INV_Pants_Plate_12");
    AtlasLootMenuItem_23.type="Subset";
    AtlasLootMenuItem_23.lootpage="NetherFury";
    AtlasLootMenuItem_23:Show();
    --Netherscale Armor
    AtlasLootMenuItem_24_Name:SetText(AL["Netherscale Armor"]);
    AtlasLootMenuItem_24_Extra:SetText(ORANGE..BabbleTrade["Dragonscale Leatherworking"]);
    AtlasLootMenuItem_24_Icon:SetTexture("Interface\\Icons\\INV_Belt_29");
    AtlasLootMenuItem_24.type="Subset";
    AtlasLootMenuItem_24.lootpage="NetherscaleArmor";
    AtlasLootMenuItem_24:Show();
    --Netherstrike Armor
    AtlasLootMenuItem_25_Name:SetText(AL["Netherstrike Armor"]);
    AtlasLootMenuItem_25_Extra:SetText(ORANGE..BabbleTrade["Dragonscale Leatherworking"]);
    AtlasLootMenuItem_25_Icon:SetTexture("Interface\\Icons\\INV_Belt_03");
    AtlasLootMenuItem_25.type="Subset";
    AtlasLootMenuItem_25.lootpage="NetherstrikeArmor";
    AtlasLootMenuItem_25:Show();
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Crafted Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootPRE60SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    --The Deadmines
    AtlasLootMenuItem_2_Name:SetText(AL["Defias Leather"]);
    AtlasLootMenuItem_2_Extra:SetText(ORANGE..BabbleZone["The Deadmines"]);
    AtlasLootMenuItem_2_Icon:SetTexture("Interface\\Icons\\INV_Pants_12");
    AtlasLootMenuItem_2.type="Subset";
    AtlasLootMenuItem_2.lootpage="DEADMINES";
    AtlasLootMenuItem_2:Show();
    --Wailing Caverns
    AtlasLootMenuItem_3_Name:SetText(AL["Embrace of the Viper"]);
    AtlasLootMenuItem_3_Extra:SetText(ORANGE..BabbleZone["Wailing Caverns"]);
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\INV_Shirt_16");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="WAILING";
    AtlasLootMenuItem_3:Show();
    --Scarlet Monastery
    AtlasLootMenuItem_4_Name:SetText(AL["Chain of the Scarlet Crusade"]);
    AtlasLootMenuItem_4_Extra:SetText(ORANGE..BabbleZone["Scarlet Monastery"]);
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\INV_Gauntlets_19");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="SCARLET";
    AtlasLootMenuItem_4:Show();
    --Blackrock Depths
    AtlasLootMenuItem_5_Name:SetText(AL["The Gladiator"]);
    AtlasLootMenuItem_5_Extra:SetText(ORANGE..BabbleZone["Blackrock Depths"]);
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\INV_Helmet_01");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="BLACKROCKD";
    AtlasLootMenuItem_5:Show();
    --Ironweave
    AtlasLootMenuItem_6_Name:SetText(AL["Ironweave Battlesuit"]);
    AtlasLootMenuItem_6_Extra:SetText(ORANGE..AL["Various Locations"]);
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\INV_Boots_Cloth_05");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="IRONWEAVE";
    AtlasLootMenuItem_6:Show();
    --Stratholme
    AtlasLootMenuItem_7_Name:SetText(AL["The Postmaster"]);
    AtlasLootMenuItem_7_Extra:SetText(ORANGE..BabbleZone["Stratholme"]);
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Boots_02");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="STRAT";
    AtlasLootMenuItem_7:Show();
    --Scholomance - Cloth
    AtlasLootMenuItem_8_Name:SetText(AL["Necropile Raiment"]);
    AtlasLootMenuItem_8_Extra:SetText(ORANGE..BabbleZone["Scholomance"]);
    AtlasLootMenuItem_8_Icon:SetTexture("Interface\\Icons\\INV_Shoulder_02");
    AtlasLootMenuItem_8.type="Subset";
    AtlasLootMenuItem_8.lootpage="ScholoCloth";
    AtlasLootMenuItem_8:Show();
    --Scholomance - Leather
    AtlasLootMenuItem_9_Name:SetText(AL["Cadaverous Garb"]);
    AtlasLootMenuItem_9_Extra:SetText(ORANGE..BabbleZone["Scholomance"]);
    AtlasLootMenuItem_9_Icon:SetTexture("Interface\\Icons\\INV_Belt_16");
    AtlasLootMenuItem_9.type="Subset";
    AtlasLootMenuItem_9.lootpage="ScholoLeather";
    AtlasLootMenuItem_9:Show();
    --Scholomance - Mail
    AtlasLootMenuItem_10_Name:SetText(AL["Bloodmail Regalia"]);
    AtlasLootMenuItem_10_Extra:SetText(ORANGE..BabbleZone["Scholomance"]);
    AtlasLootMenuItem_10_Icon:SetTexture("Interface\\Icons\\INV_Gauntlets_26");
    AtlasLootMenuItem_10.type="Subset";
    AtlasLootMenuItem_10.lootpage="ScholoMail";
    AtlasLootMenuItem_10:Show();
    --Scholomance - Plate
    AtlasLootMenuItem_11_Name:SetText(AL["Deathbone Guardian"]);
    AtlasLootMenuItem_11_Extra:SetText(ORANGE..BabbleZone["Scholomance"]);
    AtlasLootMenuItem_11_Icon:SetTexture("Interface\\Icons\\INV_Belt_12");
    AtlasLootMenuItem_11.type="Subset";
    AtlasLootMenuItem_11.lootpage="ScholoPlate";
    AtlasLootMenuItem_11:Show();
    --Scourge Invasion
    AtlasLootMenuItem_12_Name:SetText(AL["Scourge Invasion"]);
    AtlasLootMenuItem_12_Extra:SetText(ORANGE..AL["Various Locations"]);
    AtlasLootMenuItem_12_Icon:SetTexture("Interface\\Icons\\INV_Jewelry_Talisman_13");
    AtlasLootMenuItem_12.type="Subset";
    AtlasLootMenuItem_12.lootpage="ScourgeInvasion";
    AtlasLootMenuItem_12:Show();
    --Shard of the Gods
    AtlasLootMenuItem_17_Name:SetText(AL["Shard of the Gods"]);
    AtlasLootMenuItem_17_Extra:SetText(ORANGE..AL["Various Locations"]);
    AtlasLootMenuItem_17_Icon:SetTexture("Interface\\Icons\\INV_Misc_MonsterScales_15");
    AtlasLootMenuItem_17.type="Subset";
    AtlasLootMenuItem_17.lootpage="ShardOfGods";
    AtlasLootMenuItem_17:Show();
    --Zul'Gurub Rings
    AtlasLootMenuItem_18_Name:SetText(AL["Zul'Gurub Rings"]);
    AtlasLootMenuItem_18_Extra:SetText(ORANGE..BabbleZone["Zul'Gurub"]);
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\INV_Bijou_Orange");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="ZGRings";
    AtlasLootMenuItem_18:Show();
    --Spirit of Eskhandar
    AtlasLootMenuItem_19_Name:SetText(AL["Spirit of Eskhandar"]);
    AtlasLootMenuItem_19_Extra:SetText(ORANGE..AL["Various Locations"]);
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\INV_Misc_MonsterClaw_04");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="SpiritofEskhandar";
    AtlasLootMenuItem_19:Show();
    --The Twin Blades of Hakkari
    AtlasLootMenuItem_20_Name:SetText(AL["The Twin Blades of Hakkari"]);
    AtlasLootMenuItem_20_Extra:SetText(ORANGE..BabbleZone["Zul'Gurub"]);
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\INV_Sword_55");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="HakkariBlades";
    AtlasLootMenuItem_20:Show();
    --Primal Blessing
    AtlasLootMenuItem_21_Name:SetText(AL["Primal Blessing"]);
    AtlasLootMenuItem_21_Extra:SetText(ORANGE..BabbleZone["Zul'Gurub"]);
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Weapon_Hand_01");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="PrimalBlessing";
    AtlasLootMenuItem_21:Show();
    --Dal'Rend's Arms
    AtlasLootMenuItem_22_Name:SetText(AL["Dal'Rend's Arms"]);
    AtlasLootMenuItem_22_Extra:SetText(ORANGE..BabbleZone["Upper Blackrock Spire"]);
    AtlasLootMenuItem_22_Icon:SetTexture("Interface\\Icons\\INV_Sword_43");
    AtlasLootMenuItem_22.type="Subset";
    AtlasLootMenuItem_22.lootpage="DalRend";
    AtlasLootMenuItem_22:Show();
    --Spider's Kiss
    AtlasLootMenuItem_23_Name:SetText(AL["Spider's Kiss"]);
    AtlasLootMenuItem_23_Extra:SetText(ORANGE..BabbleZone["Lower Blackrock Spire"]);
    AtlasLootMenuItem_23_Icon:SetTexture("Interface\\Icons\\INV_Weapon_ShortBlade_16");
    AtlasLootMenuItem_23.type="Subset";
    AtlasLootMenuItem_23.lootpage="SpiderKiss";
    AtlasLootMenuItem_23:Show();
    --The Twin Stars
    AtlasLootMenuItem_27_Name:SetText(AL["The Twin Stars"]);
    AtlasLootMenuItem_27_Extra:SetText(ORANGE..AL["World Drop"]);
    AtlasLootMenuItem_27_Icon:SetTexture("Interface\\Icons\\INV_Jewelry_Necklace_36");
    AtlasLootMenuItem_27.type="Subset";
    AtlasLootMenuItem_27.lootpage="TwinStars";
    AtlasLootMenuItem_27:Show();
    --The Twin Blades of Azzinoth
    AtlasLootMenuItem_28_Name:SetText(AL["The Twin Blades of Azzinoth"]);
    AtlasLootMenuItem_28_Extra:SetText(ORANGE..BabbleZone["Black Temple"]);
    AtlasLootMenuItem_28_Icon:SetTexture("Interface\\Icons\\INV_Weapon_Glave_01");
    AtlasLootMenuItem_28.type="Subset";
    AtlasLootMenuItem_28.lootpage="AzzinothBlades";
    AtlasLootMenuItem_28:Show();
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Pre 60 Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootAQ40SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="AQ40Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="AQ40Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="AQ40Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="AQ40Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="AQ40Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="AQ40Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="AQ40Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="AQ40Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="AQ40Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="AQ40SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Temple of Ahn'Qiraj Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootAQ20SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="AQ20Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="AQ20Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="AQ20Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="AQ20Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="AQ20Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="AQ20Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="AQ20Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="AQ20Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="AQ20Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="AQ20SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Ruins of Ahn'Qiraj Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootZGSetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="ZGDruid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="ZGMage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="ZGPriest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="ZGShaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="ZGWarrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="ZGHunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="ZGPaladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="ZGRogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="ZGWarlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="ZGSET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Zul'Gurub Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootARENASetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="ArenaDruid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="ArenaMage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="ArenaPriest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="ArenaShaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="ArenaWarrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="ArenaHunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="ArenaPaladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="ArenaRogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="ArenaWarlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="ARENASET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Arena PvP Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootARENA2SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="Arena2Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="Arena2Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="Arena2Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="Arena2Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="Arena2Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="Arena2Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="Arena2Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="Arena2Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="Arena2Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="ARENA2SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Arena 2 PvP Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT0SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T0Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T0Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T0Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T0Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T0Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T0Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T0Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T0Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T0Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T0SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Dungeon 1/2 Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT1SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T1Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T1Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T1Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T1Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T1Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T1Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T1Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T1Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T1Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T1SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Tier 1 Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT2SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T2Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T2Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T2Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T2Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T2Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T2Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T2Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T2Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T2Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T2SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Tier 2 Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT3SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T3Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T3Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T3Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T3Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T3Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T3Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T3Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T3Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T3Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T3SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Tier 3 Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT4SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T4Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T4Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T4Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T4Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T4Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T4Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T4Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T4Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T4Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T4SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Tier 4 Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootPVPSetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="PVPDruid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="PVPMage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="PVPPriest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="PVPShaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="PVPWarrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="PVPHunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="PVPPaladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="PVPRogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="PVPWarlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="PVPSET";
    getglobal("AtlasLootItemsFrame_NEXT").lootpage="PVPWeapons2";
    getglobal("AtlasLootItemsFrame_PREV").lootpage="PVPWeapons1";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["PvP Armor Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootDS3SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Hallowed Set
    AtlasLootMenuItem_2_Name:SetText(AL["Hallowed Raiment"]);
    AtlasLootMenuItem_2_Extra:SetText(ORANGE..BabbleInventory["Cloth"]);
    AtlasLootMenuItem_2_Icon:SetTexture("Interface\\Icons\\Spell_Holy_InnerFire");
    AtlasLootMenuItem_2.type="Subset";
    AtlasLootMenuItem_2.lootpage="DS3Hallowed";
    AtlasLootMenuItem_2:Show();
    --Incanter Set
    AtlasLootMenuItem_17_Name:SetText(AL["Incanter's Regalia"]);
    AtlasLootMenuItem_17_Extra:SetText(ORANGE..BabbleInventory["Cloth"]);
    AtlasLootMenuItem_17_Icon:SetTexture("Interface\\Icons\\Ability_Creature_Cursed_04");
    AtlasLootMenuItem_17.type="Subset";
    AtlasLootMenuItem_17.lootpage="DS3Incanter";
    AtlasLootMenuItem_17:Show();
    --Mana-Etched Set
    AtlasLootMenuItem_3_Name:SetText(AL["Mana-Etched Regalia"]);
    AtlasLootMenuItem_3_Extra:SetText(ORANGE..BabbleInventory["Cloth"]);
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\INV_Elemental_Mote_Nether");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="DS3Mana";
    AtlasLootMenuItem_3:Show();
    --Oblivion Set
    AtlasLootMenuItem_18_Name:SetText(AL["Oblivion Raiment"]);
    AtlasLootMenuItem_18_Extra:SetText(ORANGE..BabbleInventory["Cloth"]);
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Creature_Cursed_03");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="DS3Oblivion";
    AtlasLootMenuItem_18:Show();
    --Assassination Set
    AtlasLootMenuItem_5_Name:SetText(AL["Assassination Armor"]);
    AtlasLootMenuItem_5_Extra:SetText(ORANGE..BabbleInventory["Leather"]);
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Ability_Rogue_SinisterCalling");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="DS3Assassin";
    AtlasLootMenuItem_5:Show();
    --Moonglade Set
    AtlasLootMenuItem_20_Name:SetText(AL["Moonglade Raiment"]);
    AtlasLootMenuItem_20_Extra:SetText(ORANGE..BabbleInventory["Leather"]);
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfRighteousness");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="DS3Moonglade";
    AtlasLootMenuItem_20:Show();
    --Wastewalker Set
    AtlasLootMenuItem_6_Name:SetText(AL["Wastewalker Armor"]);
    AtlasLootMenuItem_6_Extra:SetText(ORANGE..BabbleInventory["Leather"]);
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RapidKilling");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="DS3Wastewalker";
    AtlasLootMenuItem_6:Show();
    --Beast Lord Set
    AtlasLootMenuItem_8_Name:SetText(AL["Beast Lord Armor"]);
    AtlasLootMenuItem_8_Extra:SetText(ORANGE..BabbleInventory["Mail"]);
    AtlasLootMenuItem_8_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_Pet_Wolf");
    AtlasLootMenuItem_8.type="Subset";
    AtlasLootMenuItem_8.lootpage="DS3Beast";
    AtlasLootMenuItem_8:Show();
    --Desolation Set
    AtlasLootMenuItem_23_Name:SetText(AL["Desolation Battlegear"]);
    AtlasLootMenuItem_23_Extra:SetText(ORANGE..BabbleInventory["Mail"]);
    AtlasLootMenuItem_23_Icon:SetTexture("Interface\\Icons\\Ability_FiegnDead");
    AtlasLootMenuItem_23.type="Subset";
    AtlasLootMenuItem_23.lootpage="DS3Desolation";
    AtlasLootMenuItem_23:Show();
    --Tidefury Set
    AtlasLootMenuItem_9_Name:SetText(AL["Tidefury Raiment"]);
    AtlasLootMenuItem_9_Extra:SetText(ORANGE..BabbleInventory["Mail"]);
    AtlasLootMenuItem_9_Icon:SetTexture("Interface\\Icons\\INV_Helmet_70");
    AtlasLootMenuItem_9.type="Subset";
    AtlasLootMenuItem_9.lootpage="DS3Tidefury";
    AtlasLootMenuItem_9:Show();
    --Bold Set
    AtlasLootMenuItem_11_Name:SetText(AL["Bold Armor"]);
    AtlasLootMenuItem_11_Extra:SetText(ORANGE..BabbleInventory["Plate"]);
    AtlasLootMenuItem_11_Icon:SetTexture("Interface\\Icons\\Spell_Fire_EnchantWeapon");
    AtlasLootMenuItem_11.type="Subset";
    AtlasLootMenuItem_11.lootpage="DS3Bold";
    AtlasLootMenuItem_11:Show();
    --Doomplate Set
    AtlasLootMenuItem_26_Name:SetText(AL["Doomplate Battlegear"]);
    AtlasLootMenuItem_26_Extra:SetText(ORANGE..BabbleInventory["Plate"]);
    AtlasLootMenuItem_26_Icon:SetTexture("Interface\\Icons\\INV_Helmet_08");
    AtlasLootMenuItem_26.type="Subset";
    AtlasLootMenuItem_26.lootpage="DS3Doom";
    AtlasLootMenuItem_26:Show();
    --Righteous Set
    AtlasLootMenuItem_12_Name:SetText(AL["Righteous Armor"]);
    AtlasLootMenuItem_12_Extra:SetText(ORANGE..BabbleInventory["Plate"]);
    AtlasLootMenuItem_12_Icon:SetTexture("Interface\\Icons\\INV_Hammer_02");
    AtlasLootMenuItem_12.type="Subset";
    AtlasLootMenuItem_12.lootpage="DS3Right";
    AtlasLootMenuItem_12:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="DS3SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Dungeon 3 Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT5SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T5Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T5Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T5Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T5Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T5Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T5Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T5Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T5Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T5Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T5SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Tier 5 Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootPVP70SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="PVP70Druid1";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="PVP70Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="PVP70Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="PVP70Shaman1";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="PVP70Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="PVP70Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="PVP70Paladin1";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="PVP70Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="PVP70Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="PVP70SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["PvP Armor Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT6SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
        getglobal("AtlasLootMenuItem_"..i).isheader = false;
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(BabbleClass["Druid"]);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T6Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(BabbleClass["Mage"]);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T6Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(BabbleClass["Priest"]);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T6Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(BabbleClass["Shaman"]);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T6Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(BabbleClass["Warrior"]);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T6Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(BabbleClass["Hunter"]);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T6Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(BabbleClass["Paladin"]);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T6Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(BabbleClass["Rogue"]);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T6Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(BabbleClass["Warlock"]);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T6Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T6SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..AL["Tier 6 Sets"]);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end